// hello.cpp : Defines the class behaviors for the application.
//           Hello is a simple program which consists of a main window
//           and an "About" dialog which can be invoked by a menu choice.
//           It is intended to serve as a starting-point for new
//           applications.
//
// This is a part of the Microsoft Foundation Classes C++ library.
// Copyright (C) 1992 Microsoft Corporation
// All rights reserved.
//
// This source code is only intended as a supplement to the
// Microsoft Foundation Classes Reference and Microsoft
// WinHelp documentation provided with the library.
// See these sources for detailed information regarding the
// Microsoft Foundation Classes product.

#include "stdafx.h"
#include "resource.h"

#include "hello.h"
#include "register.h"
#include "setlock.h"
#include "ctl3d.h"
#include "rtregw.h"

/////////////////////////////////////////////////////////////////////////////

// theApp:
// Just creating this application object runs the whole application.
//
CTheApp NEAR theApp;
long Cnt,Lock;
CString Msg;

/////////////////////////////////////////////////////////////////////////////

// CMainWindow constructor:
// Create the window with the appropriate style, size, menu, etc.
//
CMainWindow::CMainWindow()
{
	LoadAccelTable( "MainAccelTable" );
	Create( NULL, cRegVer,
		WS_OVERLAPPEDWINDOW, rectDefault, NULL, "MainMenu" );
}

// OnAbout:
// This member function is called when a WM_COMMAND message with an
// IDM_ABOUT code is received by the CMainWindow class object.  The
// message map below is responsible for this routing.
//
// We create a ClDialog object using the "AboutBox" resource (see
// hello.rc), and invoke it.
//
void CMainWindow::OnAbout()
{
	CDialog about( "AboutBox", this );
	about.DoModal();
}

// CMainWindow message map:
// Associate messages with member functions.
//
// It is implied that the ON_WM_PAINT macro expects a member function
// "void OnPaint()".
//
// It is implied that members connected with the ON_COMMAND macro
// receive no arguments and are void of return type, e.g., "void OnAbout()".
//
BEGIN_MESSAGE_MAP( CMainWindow, CFrameWnd )
	//{{AFX_MSG_MAP( CMainWindow )
	ON_COMMAND( IDM_ABOUT, OnAbout )
	ON_COMMAND(ID_SYSTEM_EXIT, OnSystemExit)
	ON_COMMAND(ID_SYSTEM_REGISTERNOW, OnRegister)
	ON_COMMAND(ID_REMOVE_LOCK, OnRemoveLock)
	ON_COMMAND(ID_REMOVE_REGISTERINFORMATION, OnRemoveRegister)
	ON_WM_CREATE()
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CTheApp

// InitInstance:
// When any CTheApp object is created, this member function is automatically
// called.  Any data may be set up at this point.
//
// Also, the main window of the application should be created and shown here.
// Return TRUE if the initialization is successful.
//
BOOL CTheApp::InitInstance()
{
	char pBuf[20];
	
   Ctl3dRegister(m_hInstance);
   Ctl3dAutoSubclass(m_hInstance);
	TRACE( "HELLO WORLD\n" );

	SetDialogBkColor();     // hook gray dialogs (was default in MFC V1)

	RTSetSaveFile("REGC.INI");  // save registration information into REGC.INI
	RTSetSaveKind(SAVE_INI);	 // it should be INI file
   Cnt = 1;
   Lock = 0;
   if(RTCheckReg(cPrg)<0)
   {
		Msg = "This an unregister version of the DEMO program.\n";
		if(RTIsCountLock(cPrg))
		{
			Lock = 1;
			Cnt = RTCheckCountLock(cPrg);
			Msg += "You have ";
			Msg += ltoa(Cnt,pBuf,10);
			Msg += " more calls to test it.\n";
			
		}
		else if(RTIsDateLock(cPrg))
		{
			Lock = 2;
			Cnt = RTCheckDateLock(cPrg);
			Msg += "You have ";
			Msg += ltoa(Cnt,pBuf,10);
			Msg += " more days to test it.\n";
		}
		Msg += "Do you want to register now?";
		if(((AfxMessageBox(Msg,MB_YESNO+MB_ICONQUESTION,0)==IDNO) || (!Register())) && Lock==0)
			SetLock();
	}
	
	if(Cnt>0)
	{
		m_pMainWnd = new CMainWindow();
		m_pMainWnd->ShowWindow( m_nCmdShow );
		m_pMainWnd->UpdateWindow();
		return TRUE;
	}
	else return FALSE;
}

BOOL CTheApp::ExitInstance()
{
   Ctl3dUnregister(m_hInstance);
	return TRUE;
}

void CMainWindow::OnSystemExit()
{
	// TODO: Add your command handler code here
	::PostQuitMessage(0);
}

void CMainWindow::OnRegister()
{
	// TODO: Add your command handler code here
	if(Register())
	{
		SetWindowText(cRegVer);
		GetMenu()->ModifyMenu(ID_SYSTEM_REGISTERNOW,MF_BYCOMMAND+MF_DISABLED);
		DrawMenuBar();
	}		
}

void WndCenter(CWnd *w)
{
	CRect rw,rd;
	
	w->GetWindowRect(&rw);
	CWnd::GetDesktopWindow()->GetWindowRect(&rd);
	w->SetWindowPos(&CWnd::wndNoTopMost,
					 ((rd.right-rd.left+1)-(rw.right-rw.left+1))/2,
					 ((rd.bottom-rd.top+1)-(rw.bottom-rw.top+1))/2,
					 -1,-1,SWP_NOSIZE+SWP_NOZORDER);
}

void CMainWindow::OnRemoveLock()
{
	// TODO: Add your command handler code here
	if(RTIsCountLock(cPrg))
		RTDelCountLock(cPrg);
	else if(RTIsDateLock(cPrg))
		RTDelDateLock(cPrg);
}

void CMainWindow::OnRemoveRegister()
{
	// TODO: Add your command handler code here
	RTDelReg(cPrg);
}

int CMainWindow::OnCreate(LPCREATESTRUCT lpCreateStruct)
{
	if (CFrameWnd ::OnCreate(lpCreateStruct) == -1)
		return -1;
	
	// TODO: Add your specialized creation code here
	switch(Lock)
	{
		case 0:
		{
			SetWindowText(cRegVer);
			GetMenu()->ModifyMenu(ID_SYSTEM_REGISTERNOW,MF_BYCOMMAND+MF_DISABLED);
			DrawMenuBar();
			break;
		}
		case 1:
		{
			CString Msg;
			sprintf(Msg.GetBuffer(80),cDemoVer,Cnt,"times");
			SetWindowText(Msg);
			Msg.ReleaseBuffer();
			break;
		}
		case 2:
		{
			CString Msg;
			sprintf(Msg.GetBuffer(80),cDemoVer,Cnt,"days");
			SetWindowText(Msg);
			Msg.ReleaseBuffer();
			break;
		}
	}	
	return 0;
}
